<?php
namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * VM\ApiBundle\Entity\BankServiceOptions
 *
 * @ORM\Table(name="bank_service_options")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\BankServiceOptionsRepository")
 *
 * @ExclusionPolicy("all")
 */
class BankServiceOptions
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $name;

    /**
     * @var string $description
     *
     * @ORM\Column(name="description", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $description = '';

    /**
     * @var string $isValue
     *
     * @ORM\Column(name="is_value", type="boolean")
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $isValue = false;

    /**
     * @var string $flags
     *
     * @ORM\Column(name="flags", type="string", length=100, nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $flags;

    /**
     * @var integer
     *
     * @ORM\Column(name="bank_service_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({})
     */
    private $bankServiceId;

    /**
     * @var integer
     *
     * @ORM\Column(name="cost", type="decimal", precision=13, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails", "details","companyDetails", "companyBankServiceDetails"})
     */
    private $cost = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="percent", type="decimal", precision=13, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails", "details","companyDetails", "companyBankServiceDetails"})
     */
    private $percent = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="duration", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails", "companyBankServiceDetails"})
     */
    private $duration = 0;

    /**
     * @var boolean
     *
     * @ORM\Column(name="wibor", type="boolean")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails", "companyBankServiceDetails"})
     */
    private $wibor = false;

    /**
     * @ORM\ManyToOne(targetEntity="BankService",inversedBy="types")
     * @ORM\JoinColumn(name="bank_service_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $bankService;

//    /**
//     * Inverse Side
//     *
//     * @ORM\ManyToMany(targetEntity="Company", mappedBy="bankServiceOptions")
//     */
//    private $company;

    /**
     * @ORM\OneToMany(targetEntity="CompanyBankServiceOption", mappedBy="option")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails", "companyBankServiceDetails"})
     */
    protected $companyBankServiceOptions;

    /**
     * @ORM\OneToMany(targetEntity="SummaryRoundBankServiceOption", mappedBy="bankServiceOption")
     */
    protected $summaryRoundBankServiceOption;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return BankServiceOptions
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set bankServiceId
     *
     * @param integer $bankServiceId
     * @return BankServiceOptions
     */
    public function setBankServiceId($bankServiceId)
    {
        $this->bankServiceId = $bankServiceId;

        return $this;
    }

    /**
     * Get bankServiceId
     *
     * @return integer
     */
    public function getBankServiceId()
    {
        return $this->bankServiceId;
    }

    /**
     * Set bankService
     *
     * @param \VM\ApiBundle\Entity\BankService $bankService
     * @return BankServiceOptions
     */
    public function setBankService(\VM\ApiBundle\Entity\BankService $bankService = null)
    {
        $this->bankService = $bankService;

        return $this;
    }

    /**
     * Get bankService
     *
     * @return \VM\ApiBundle\Entity\BankService
     */
    public function getBankService()
    {
        return $this->bankService;
    }

    /**
     * Set isValue
     *
     * @param boolean $isValue
     * @return BankServiceOptions
     */
    public function setIsValue($isValue)
    {
        $this->isValue = $isValue;

        return $this;
    }

    /**
     * Get isValue
     *
     * @return boolean
     */
    public function getIsValue()
    {
        return $this->isValue;
    }

    /**
     * Add company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return BankServiceOptions
     */
    public function addCompany(\VM\ApiBundle\Entity\Company $company)
    {
        $this->company[] = $company;

        return $this;
    }

    /**
     * Remove company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     */
    public function removeCompany(\VM\ApiBundle\Entity\Company $company)
    {
        $this->company->removeElement($company);
    }

    /**
     * Get company
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->company = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Add companyBankServiceOption
     *
     * @param \VM\ApiBundle\Entity\CompanyBankServiceOption $companyBankServiceOption
     * @return BankServiceOptions
     */
    public function addCompanyBankServiceOption(\VM\ApiBundle\Entity\CompanyBankServiceOption $companyBankServiceOption)
    {
        $this->companyBankServiceOption[] = $companyBankServiceOption;

        return $this;
    }

    /**
     * Remove companyBankServiceOption
     *
     * @param \VM\ApiBundle\Entity\CompanyBankServiceOption $companyBankServiceOption
     */
    public function removeCompanyBankServiceOption(\VM\ApiBundle\Entity\CompanyBankServiceOption $companyBankServiceOption)
    {
        $this->companyBankServiceOption->removeElement($companyBankServiceOption);
    }

    /**
     * Get companyBankServiceOption
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCompanyBankServiceOption()
    {
        return $this->companyBankServiceOption;
    }

    /**
     * Set flags
     *
     * @param string $flags
     * @return BankServiceOptions
     */
    public function setFlags($flags)
    {
        $this->flags = $flags;
    
        return $this;
    }

    /**
     * Get flags
     *
     * @return string 
     */
    public function getFlags()
    {
        return $this->flags;
    }

    /**
     * Add summaryRoundBankServiceOption
     *
     * @param \VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption
     * @return BankServiceOptions
     */
    public function addSummaryRoundBankServiceOption(\VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption)
    {
        $this->summaryRoundBankServiceOption[] = $summaryRoundBankServiceOption;
    
        return $this;
    }

    /**
     * Remove summaryRoundBankServiceOption
     *
     * @param \VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption
     */
    public function removeSummaryRoundBankServiceOption(\VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption)
    {
        $this->summaryRoundBankServiceOption->removeElement($summaryRoundBankServiceOption);
    }

    /**
     * Get summaryRoundBankServiceOption
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSummaryRoundBankServiceOption()
    {
        return $this->summaryRoundBankServiceOption;
    }

    /**
     * Set cost
     *
     * @param float $cost
     * @return BankServiceOptions
     */
    public function setCost($cost)
    {
        $this->cost = $cost;
    
        return $this;
    }

    /**
     * Get cost
     *
     * @return float 
     */
    public function getCost()
    {
        return $this->cost;
    }

    /**
     * Set percent
     *
     * @param float $percent
     * @return BankServiceOptions
     */
    public function setPercent($percent)
    {
        $this->percent = $percent;
    
        return $this;
    }

    /**
     * Get percent
     *
     * @return float 
     */
    public function getPercent()
    {
        return $this->percent;
    }

    /**
     * Get companyBankServiceOptions
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyBankServiceOptions()
    {
        return $this->companyBankServiceOptions;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return BankServiceOptions
     */
    public function setDescription($description)
    {
        $this->description = $description;
    
        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set duration
     *
     * @param integer $duration
     * @return BankServiceOptions
     */
    public function setDuration($duration)
    {
        $this->duration = $duration;
    
        return $this;
    }

    /**
     * Get duration
     *
     * @return integer 
     */
    public function getDuration()
    {
        return $this->duration;
    }

    /**
     * Set wibor
     *
     * @param boolean $wibor
     * @return BankServiceOptions
     */
    public function setWibor($wibor)
    {
        $this->wibor = $wibor;
    
        return $this;
    }

    /**
     * Get wibor
     *
     * @return boolean 
     */
    public function getWibor()
    {
        return $this->wibor;
    }
}